package ru.yandex.msearch.proxy.api.async.mail.relevance.search;

import ru.yandex.dbfields.MailIndexFields;

import ru.yandex.json.parser.JsonException;

import ru.yandex.logger.PrefixedLogger;

import ru.yandex.msearch.proxy.api.async.mail.documents.Document;

import ru.yandex.msearch.proxy.api.async.mail.relevance.FactorGroup;
import ru.yandex.msearch.proxy.api.async.mail.relevance.RelevanceException;

import ru.yandex.msearch.proxy.api.async.mail.relevance.search.factors.AbstractDocumentFactor;

import ru.yandex.parser.uri.CgiParams;

public class LogReceivedDateFactorFactory
    extends AbstractDocumentFactorFactory
{
    public LogReceivedDateFactorFactory(final String name, final int index) {
        super(name, index);
    }

    @Override
    public FactorGroup<Document> create(
        final CgiParams params,
        final PrefixedLogger logger)
    {
        double ts = System.currentTimeMillis() / 1000.0;
        return new LogReceivedDateFactor(index(), ts);
    }

    private static class LogReceivedDateFactor extends AbstractDocumentFactor {
        private final double timestamp;

        public LogReceivedDateFactor(final int index, final double timestamp) {
            super(index);
            this.timestamp = timestamp;
        }

        @Override
        public double calc(
            final Document doc, final String request)
            throws RelevanceException, JsonException
        {
            String rcvDateStr =
                doc.doc().attrs().get(MailIndexFields.RECEIVED_DATE);

            if (rcvDateStr == null) {
                return 0;
            }

            long receiveDate = Long.parseLong(rcvDateStr);

            double age;
            if (receiveDate > timestamp) {
                age = 0.0;
            } else {
                age = Math.log(1.0 + (timestamp - receiveDate) / 3600.0);
            }

            return age;
        }
    }
}
