package ru.yandex.msearch.proxy.api.async.mail.relevance.search;

import java.util.List;

import ru.yandex.json.parser.JsonException;

import ru.yandex.logger.PrefixedLogger;
import ru.yandex.msearch.proxy.api.async.mail.documents.Document;
import ru.yandex.msearch.proxy.api.async.mail.documents.DocumentsGroup;
import ru.yandex.msearch.proxy.api.async.mail.relevance.FactorsContext;
import ru.yandex.msearch.proxy.api.async.mail.relevance.RelevanceException;
import ru.yandex.parser.uri.CgiParams;

public class MailSearchDateOrderRelevanceSorter
    extends AbstractMailSearchRelevanceSorter
{
    public MailSearchDateOrderRelevanceSorter(
        final MailSearchRelevanceFactory factory,
        final FactorsContext<Document> context,
        final CgiParams params,
        final PrefixedLogger logger)
    {
        super(factory, context, params, logger);
    }

    @Override
    public String name() {
        return "date-order";
    }

    @Override
    public List<RankedDocument> sort(
        final List<? extends DocumentsGroup> docs,
        final String request)
        throws RelevanceException, JsonException
    {
        List<RankedDocument> rankedDocs = prepare(docs, request);

        for (RankedDocument doc: rankedDocs) {
            double[] values = calculate(doc.best(), request);
            doc.score(0);
            doc.factors(values);
        }

        return rankedDocs;
    }

    @Override
    public int minSerpSize() {
        return 0;
    }

    @Override
    public int rankedPositions() {
        return -1;
    }
}
