package ru.yandex.msearch.proxy.api.async.mail.relevance.search;

import java.util.List;

import ru.yandex.logger.PrefixedLogger;

import ru.yandex.msearch.proxy.api.async.mail.documents.Document;

import ru.yandex.msearch.proxy.api.async.mail.relevance.AbstractSorterFactory;
import ru.yandex.msearch.proxy.api.async.mail.relevance.FactorGroupFactory;
import ru.yandex.msearch.proxy.api.async.mail.relevance.FactorsContext;

import ru.yandex.parser.uri.CgiParams;

public class MailSearchDateOrderSorterFactory
    extends AbstractSorterFactory<AbstractMailSearchRelevanceSorter, Document>
    implements MailSearchSorterFactory
{
    private final FactorsContext<Document> context;
    private final MailSearchRelevanceFactory factory;

    public MailSearchDateOrderSorterFactory(
        final MailSearchRelevanceFactory factory,
        final List<FactorGroupFactory<Document>> factors,
        final List<FactorGroupFactory<Document>> logFactors)
    {
        super("date", factors, logFactors);

        this.factory = factory;
        this.context = new FactorsContext<>(factories, names, indexes);
    }

    @Override
    public MailSearchDateOrderRelevanceSorter build(
        final CgiParams params,
        final PrefixedLogger logger)
    {
        return new MailSearchDateOrderRelevanceSorter(
            factory,
            context,
            params,
            logger);
    }

    @Override
    public String toString() {
        return name();
    }
}
