package ru.yandex.msearch.proxy.api.async.mail.relevance.search;

import java.util.List;
import java.util.Map;

import ru.yandex.http.config.FilterSearchConfigDefaults;
import ru.yandex.logger.PrefixedLogger;

import ru.yandex.matrixnet.MatrixnetModel;
import ru.yandex.msearch.proxy.api.async.mail.SearchSession;
import ru.yandex.msearch.proxy.api.async.mail.documents.Document;
import ru.yandex.msearch.proxy.api.async.mail.relevance.FactorsContext;
import ru.yandex.msearch.proxy.api.async.mail.relevance.FactorGroupFactory;

import ru.yandex.msearch.proxy.api.async.mail.relevance.MatrixnetSorterFactory;
import ru.yandex.parser.config.ConfigException;

import ru.yandex.parser.uri.CgiParams;

public class MailSearchModelSorterFactory
    extends MatrixnetSorterFactory<AbstractMailSearchRelevanceSorter, Document>
    implements MailSearchSorterFactory
{
    private final MailSearchRelevanceFactory relevanceFactory;
    private final MailSearchFactorsContext context;

    public MailSearchModelSorterFactory(
        final MailSearchRelevanceFactory relevanceFactory,
        final ImmutableMailSearchRelevanceConfig modelConfig,
        final List<FactorGroupFactory<Document>> factors,
        final List<FactorGroupFactory<Document>> logFactors)
        throws ConfigException
    {
        super(modelConfig, factors, logFactors);

        this.relevanceFactory = relevanceFactory;
        this.context = new MailSearchFactorsContext(
            model(),
            modelConfig,
            factories,
            names,
            indexes);
    }

    @Deprecated
    @Override
    public AbstractMailSearchRelevanceSorter build(
        final CgiParams params,
        final PrefixedLogger logger)
    {
        logger.warning("Creating mail search model with default batch size");
        return new ModelMailSearchRelevanceSorter(
            relevanceFactory,
            context,
            params,
            logger,
            FilterSearchConfigDefaults.INSTANCE.batchSize());
    }

    @Override
    public AbstractMailSearchRelevanceSorter build(
        final SearchSession session)
    {
        return new ModelMailSearchRelevanceSorter(
            relevanceFactory,
            context,
            session);
    }

    public static class MailSearchFactorsContext
        extends FactorsContext<Document>
    {
        private final MatrixnetModel model;
        private final ImmutableMailSearchRelevanceConfig config;

        public MailSearchFactorsContext(
            final MatrixnetModel model,
            final ImmutableMailSearchRelevanceConfig config,
            final Map<String, FactorGroupFactory<Document>> factories,
            final List<String> names,
            final int[] logIndexes)
        {
            super(factories, names, logIndexes);

            this.model = model;
            this.config = config;
        }

        public ImmutableMailSearchRelevanceConfig config() {
            return config;
        }

        public MatrixnetModel model() {
            return model;
        }
    }

    @Override
    public String toString() {
        return name();
    }
}
