package ru.yandex.msearch.proxy.api.async.mail.relevance.search;

import java.util.Map;

import ru.yandex.msearch.proxy.config.AbstractRelevanceConfigBuilder;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public class MailSearchRelevanceConfigBuilder
    extends AbstractRelevanceConfigBuilder<MailSearchRelevanceConfigBuilder>
    implements MailSearchRelevanceConfig
{
    public static final String RANKED_POSITIONS = "ranked-positions";
    public static final String BOOSTED = "boosted";
    public static final String MIN_SERP_SIZE = "min-serp-size";

    private int rankedPositions;
    private int minSerpSize;
    private boolean boosted;

    public MailSearchRelevanceConfigBuilder() {
        this(MailSearchRelevanceConfigDefaults.INSTANCE);
    }

    public MailSearchRelevanceConfigBuilder(
        final MailSearchRelevanceConfig config)
    {
        super(config);

        rankedPositions(config.rankedPositions());
        boosted(config.boosted());
        minSerpSize(config.minSerpSizeRanking());
    }

    public MailSearchRelevanceConfigBuilder(
        final IniConfig config,
        final MailSearchRelevanceConfig defaults)
        throws ConfigException
    {
        super(config, defaults);

        boosted = config.getBoolean(BOOSTED, defaults.boosted());

        rankedPositions =
            config.getInt(RANKED_POSITIONS, defaults.rankedPositions());
        minSerpSize =
            config.getInt(MIN_SERP_SIZE, defaults.minSerpSizeRanking());

    }

    public MailSearchRelevanceConfigBuilder rankedPositions(final int value) {
        this.rankedPositions = value;
        return this;
    }

    @Override
    public MailSearchRelevanceConfigBuilder self() {
        return this;
    }

    @Override
    public int rankedPositions() {
        return rankedPositions;
    }

    public MailSearchRelevanceConfigBuilder minSerpSize(final int value) {
        this.minSerpSize = value;
        return this;
    }

    @Override
    public int minSerpSizeRanking() {
        return minSerpSize;
    }

    @Override
    public boolean boosted() {
        return boosted;
    }

    public MailSearchRelevanceConfigBuilder boosted(final boolean boosted) {
        this.boosted = boosted;
        return self();
    }

    @Override
    public Map<String, String> toMap() {
        Map<String, String> result = super.toMap();
        result.put(RANKED_POSITIONS, String.valueOf(rankedPositions()));
        result.put(BOOSTED, String.valueOf(boosted()));
        result.put(MIN_SERP_SIZE, String.valueOf(minSerpSizeRanking()));
        return result;
    }
}
