package ru.yandex.msearch.proxy.api.async.mail.relevance.search;

import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;

import ru.yandex.msearch.proxy.api.async.mail.documents.Document;
import ru.yandex.msearch.proxy.api.async.mail.documents.DocumentsGroup;

public class RankedDocument implements DocumentsGroup {
    public static final Comparator<RankedDocument> SCORE_COMPARATOR =
        new Comparator<RankedDocument>() {
            @Override
            public int compare(
                final RankedDocument o1, final RankedDocument o2)
            {
                return -Double.compare(o1.score, o2.score);
            }
        };

    public static final Comparator<RankedDocument> DATE_COMPARATOR =
        new Comparator<RankedDocument>() {
            @Override
            public int compare(
                final RankedDocument o1, final RankedDocument o2)
            {
                return Integer.compare(o1.nonRankedPos, o2.nonRankedPos);
            }
        };

    private final Document document;
    private double[] factors;
    private double score;
    private int nonRankedPos;

    public void factors(final double[] factors) {
        this.factors = factors;
    }

    public double[] factors() {
        return factors;
    }

    public void score(final double score) {
        this.score = score;
    }

    public int nonRankedPos() {
        return nonRankedPos;
    }

    public void nonRankedPos(final int nonRankedPos) {
        this.nonRankedPos = nonRankedPos;
    }

    public RankedDocument(
        final Document document,
        final int nonRankedPos)
    {
        this.document = document;
        this.nonRankedPos = nonRankedPos;
    }

    public double score() {
        return score;
    }

    @Override
    public String id() {
        return document.id();
    }

    @Override
    public void add(final Document doc) {
    }

    @Override
    public Document best() {
        return document;
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public Iterator<Document> iterator() {
        return Collections.singletonList(document).iterator();
    }
}
