package ru.yandex.msearch.proxy.api.async.mail.relevance.search;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

import ru.yandex.msearch.proxy.api.async.mail.documents.Document;
import ru.yandex.msearch.proxy.api.async.mail.documents.Documents;
import ru.yandex.msearch.proxy.api.async.mail.documents.DocumentsGroup;
import ru.yandex.msearch.proxy.api.async.mail.relevance.search.RankedDocument;

public class RankingDocuments implements Documents {
    private final List<RankedDocument> documents;
    private final long relevant;
    private long total;

    public RankingDocuments(
        final List<RankedDocument> documents)
    {
        this.documents = documents;

        this.relevant = 0;
    }

    public RankingDocuments(
        final List<RankedDocument> documents,
        final long relevant)
    {
        this.documents = documents;
        this.relevant = relevant;
    }

    public RankingDocuments(final int length, final int relevant) {
        this.documents = new ArrayList<>(length);
        this.relevant = relevant;
    }

    public void add(final RankedDocument doc) {
        this.documents.add(doc);
    }

    @Override
    public long relevant() {
        return relevant;
    }

    @Override
    public void add(
        final String groupId,
        final Document doc)
    {
    }

    @Override
    public int size() {
        return documents.size();
    }

    @Override
    public void clear() {
        documents.clear();
    }

    @Override
    public List<? extends DocumentsGroup> sort() {
        return documents;
    }

    @Override
    public Comparator<Document> comparator() {
        return null;
    }

    @Override
    public Iterator<DocumentsGroup> iterator() {
        return new Itr();
    }

    public List<RankedDocument> documents() {
        return documents;
    }

    private class Itr implements Iterator<DocumentsGroup> {
        int cursor;

        public boolean hasNext() {
            return cursor != size();
        }

        public DocumentsGroup next() {
            int i = cursor;
            if (i >= size())
                throw new NoSuchElementException();

            cursor = i + 1;
            return documents.get(i);
        }
    }

    @Override
    public void total(final long total) {
        this.total = total;
    }

    @Override
    public long total() {
        return total;
    }
}
