package ru.yandex.msearch.proxy.api.async.mail.relevance.search.factors;

import ru.yandex.logger.PrefixedLogger;
import ru.yandex.msearch.proxy.api.async.mail.documents.Document;

import ru.yandex.msearch.proxy.api.async.mail.relevance.FactorGroup;
import ru.yandex.msearch.proxy.api.async.mail.relevance.search.factors.AbstractDocumentFactor;

import ru.yandex.msearch.proxy.api.async.mail.relevance.search.AbstractDocumentFactorFactory;
import ru.yandex.parser.uri.CgiParams;

public class ClickFactory extends AbstractDocumentFactorFactory {
    private final String field;

    public ClickFactory(
        final String name,
        final String field,
        final int index)
    {
        super(name, index);

        this.field = field;
    }

    @Override
    public FactorGroup create(
        final CgiParams params,
        final PrefixedLogger logger)
    {
        return new ClickFactor(index(), field);
    }

    public static class ClickFactor extends AbstractDocumentFactor {
        private final String field;
        private double max = 0;

        public ClickFactor(final int index, final String field) {
            super(index);

            this.field = field;
        }

        @Override
        public double calc(final Document doc, final String request) {
            long value = extract(doc);
            if (max > 0) {
                return value / max;
            }

            return 0;
        }

        private long extract(final Document doc) {
            String value = doc.doc().attrs().getOrDefault(field, null);
            if (value == null) {
                return 0;
            }

            return Long.parseLong(value);
        }

        @Override
        public void prepare(final Document doc, final String request) {
            long value = extract(doc);
            if (max <= value) {
                max = value;
            }
        }

        @Override
        public boolean normalized() {
            return false;
        }
    }
}