package ru.yandex.msearch.proxy.api.async.mail.relevance.search.factors;

import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

import ru.yandex.http.util.BadRequestException;

import ru.yandex.json.parser.JsonException;

import ru.yandex.logger.PrefixedLogger;

import ru.yandex.msearch.proxy.api.async.mail.documents.Document;
import ru.yandex.msearch.proxy.api.async.mail.relevance.FactorGroup;
import ru.yandex.msearch.proxy.api.async.mail.relevance.RelevanceException;

import ru.yandex.msearch.proxy.api.async.mail.relevance.search.AbstractDocumentFactorFactory;

import ru.yandex.parser.uri.CgiParams;

public class DaytimeFactorFactory extends AbstractDocumentFactorFactory {
    public DaytimeFactorFactory(final String name, final int index) {
        super(name, index);
    }

    @Override
    public FactorGroup<Document> create(
        final CgiParams params,
        final PrefixedLogger logger)
    {
        int tzoffset = 0;
        try {
            tzoffset = params.getInt("tzoffset", 0);
        } catch (BadRequestException bre) {
            logger.log(
                Level.WARNING,
                "Unable fetch tzoffset",
                bre);
        }

        if (Math.abs(tzoffset) > 24 * 60) {
            logger.warning("Invalid tzoffset " + tzoffset);
            tzoffset = 0;
        }

        tzoffset = (int) TimeUnit.MINUTES.toMillis(tzoffset);

        return new DaytimeFactor(index(), tzoffset);
    }

    private static class DaytimeFactor extends AbstractDocumentFactor {
        private final double value;

        private DaytimeFactor(final int index, final int tzoffset) {
            super(index);

            DateTime dt = new DateTime(DateTimeZone.forOffsetMillis(tzoffset));
            this.value = dt.minuteOfDay().get() / 60.0;
        }

        @Override
        public double calc(
            final Document doc,
            final String request)
            throws RelevanceException, JsonException
        {
            return value;
        }
    }
}
