package ru.yandex.msearch.proxy.api.async.mail.relevance.search.factors;


import ru.yandex.json.parser.JsonException;

import ru.yandex.logger.PrefixedLogger;

import ru.yandex.msearch.proxy.api.async.mail.documents.Document;

import ru.yandex.msearch.proxy.api.async.mail.relevance.FactorGroup;
import ru.yandex.msearch.proxy.api.async.mail.relevance.RelevanceException;
import ru.yandex.msearch.proxy.api.async.mail.relevance.search.AbstractDocumentFactorFactory;
import ru.yandex.msearch.proxy.api.async.mail.relevance.search.factors.AbstractDocumentFactor;
import ru.yandex.parser.uri.CgiParams;

public class DocFieldFactorFactory extends AbstractDocumentFactorFactory {
    private final String field;

    public DocFieldFactorFactory(
        final String name,
        final String field,
        final int index)
    {
        super(name, index);

        this.field = field;
    }

    @Override
    public FactorGroup<Document> create(
        final CgiParams params,
        final PrefixedLogger logger)
    {
        return new DocFieldFactor(index(), field);
    }

    private static class DocFieldFactor extends AbstractDocumentFactor {
        private final String field;

        public DocFieldFactor(
            final int index,
            final String field)
        {
            super(index);

            this.field = field;
        }

        @Override
        public double calc(
            final Document doc,
            final String request)
            throws RelevanceException, JsonException
        {
            String value = doc.doc().attrs().getOrDefault(field, "0");
            if (value == null) {
                return 0;
            }

            try {
                return Double.parseDouble(value);
            } catch (NumberFormatException nfe) {
                throw new RelevanceException("Invalid score value " + value);
            }
        }
    }
}
