package ru.yandex.msearch.proxy.api.async.mail.relevance.search.factors;

import ru.yandex.dbfields.MailIndexFields;
import ru.yandex.json.parser.JsonException;

import ru.yandex.logger.PrefixedLogger;

import ru.yandex.msearch.proxy.api.async.mail.documents.Document;

import ru.yandex.msearch.proxy.api.async.mail.relevance.FactorGroup;
import ru.yandex.msearch.proxy.api.async.mail.relevance.RelevanceException;
import ru.yandex.msearch.proxy.api.async.mail.relevance.search.factors.AbstractDocumentFactor;
import ru.yandex.msearch.proxy.api.async.mail.relevance.search.AbstractDocumentFactorFactory;
import ru.yandex.parser.uri.CgiParams;

public class FidFactorFactory extends AbstractDocumentFactorFactory {
    public FidFactorFactory(final String name, final int index) {
        super(name, index);
    }

    @Override
    public FactorGroup<Document> create(
        final CgiParams params,
        final PrefixedLogger logger)
    {
        return new FidFactor(index());
    }

    private static class FidFactor extends AbstractDocumentFactor {
        public FidFactor(final int index) {
            super(index);
        }

        @Override
        public double calc(
            final Document doc,
            final String request)
            throws RelevanceException, JsonException
        {
            long fid = doc.envelope().getLong("fid", -1L);
            if (fid < 0) {
                String fidStr = doc.doc().attrs().get(MailIndexFields.FID);
                if (fidStr != null) {
                    fid = Long.parseLong(fidStr);
                }
            }

            return fid;
        }
    }
}