package ru.yandex.msearch.proxy.api.async.mail.relevance.search.factors;


import java.util.List;

import ru.yandex.dbfields.MailIndexFields;
import ru.yandex.json.dom.JsonList;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.parser.JsonException;
import ru.yandex.logger.PrefixedLogger;
import ru.yandex.msearch.proxy.api.async.mail.documents.Document;
import ru.yandex.msearch.proxy.api.async.mail.relevance.FactorGroup;
import ru.yandex.msearch.proxy.api.async.mail.relevance.FactorGroupFactory;
import ru.yandex.msearch.proxy.api.async.mail.relevance.NormalizedFactorGroup;
import ru.yandex.msearch.proxy.api.async.mail.relevance.RelevanceException;
import ru.yandex.msearch.proxy.ora.wmi.fields.WmiField;
import ru.yandex.parser.uri.CgiParams;
import ru.yandex.search.document.mail.MailMetaInfo;

public class MessageTypesFactorFactory implements FactorGroupFactory {
    public static final String NAME = "mtype";
    private final int startIndex;
    private final int[] mtypes;
    private final List<String> names;

    public MessageTypesFactorFactory(
        final int mtypes[],
        final List<String> names,
        final int startIndex)
    {
        this.mtypes = mtypes;
        this.startIndex = startIndex;
        this.names = names;
    }

    @Override
    public FactorGroup create(
        final CgiParams params,
        final PrefixedLogger logger)
    {
        return new MessageTypesFactor(WmiField.TYPES, startIndex, mtypes);
    }

    @Override
    public int size() {
        return mtypes.length;
    }

    @Override
    public int startIndex() {
        return startIndex;
    }

    @Override
    public List<String> names() {
        return names;
    }

    @Override
    public String groupName() {
        return NAME;
    }

    public static class MessageTypesFactor
        implements NormalizedFactorGroup<Document>
    {
        private final String field;
        private final int maxTypeValue;
        private final int[] mTypes;
        private boolean[] got;
        private final int startIndex;

        public MessageTypesFactor(
            final String field,
            final int startIndex,
            final int[] types)
        {
            this.field = field;
            this.mTypes = types;
            this.startIndex = startIndex;

            int max = 0;
            for (int i = 0; i < types.length; i++) {
                if (types[i] > max) {
                    max = types[i];
                }
            }

            this.maxTypeValue = max;
        }

        @Override
        public void calc(
            final Document doc,
            final String request,
            final double[] res)
            throws RelevanceException, JsonException
        {
            JsonList types = doc.envelope().getListOrNull(field);
            got = new boolean[maxTypeValue + 1];
            if (types != null) {
                for (JsonObject typeObj : types) {
                    long typeIndex = typeObj.asLong();
                    if (typeIndex <= maxTypeValue) {
                        got[(int) typeIndex] = true;
                    }
                }
            } else {
                String luceneTypes =
                    doc.doc().attrs().get(MailMetaInfo.MESSAGE_TYPE);
                if (luceneTypes != null) {
                    for (String split: luceneTypes.split(" ")) {
                        if (split.length() > 0
                            && Character.isDigit(split.charAt(0)))
                        {
                            long typeIndex = Long.parseLong(split.trim());
                            if (typeIndex <= maxTypeValue) {
                                got[(int) typeIndex] = true;
                            }
                        }
                    }
                }
            }

            if (res == null) {
                return;
            }

            for (int i = 0; i < mTypes.length; i++) {
                if (got[mTypes[i]]) {
                    res[startIndex + i] = 1.0;
                } else {
                    res[startIndex + i] = 0.0;
                }
            }
        }
    }
}