package ru.yandex.msearch.proxy.api.async.mail.relevance.search.factors;

import ru.yandex.logger.PrefixedLogger;
import ru.yandex.msearch.proxy.api.async.mail.documents.Document;
import ru.yandex.msearch.proxy.api.async.mail.relevance.FactorGroup;
import ru.yandex.msearch.proxy.api.async.mail.relevance.MtypeRequestProcessorFactory;
import ru.yandex.msearch.proxy.api.async.mail.relevance.search.factors.AbstractDocumentFactor;
import ru.yandex.msearch.proxy.api.async.mail.relevance.search.AbstractDocumentFactorFactory;
import ru.yandex.msearch.proxy.api.async.mail.rules.PersonalFactorsGatherRule;
import ru.yandex.parser.uri.CgiParams;

public class NormalizedClickFactory extends AbstractDocumentFactorFactory {
    private final String field;

    public NormalizedClickFactory(
        final String name,
        final String field,
        final int index)
    {
        super(name, index);

        this.field = field;
    }

    @Override
    public FactorGroup<Document> create(
        final CgiParams params,
        final PrefixedLogger logger)
    {
        return new NormalizedeClickFactor(field, index());
    }

    public static class NormalizedeClickFactor extends AbstractDocumentFactor {
        private final String field;

        public NormalizedeClickFactor(
            final String field,
            final int index)
        {
            super(index);

            this.field = field;
        }

        @Override
        public double calc(final Document doc, final String request) {
            String clickValueStr = doc.doc().attrs().getOrDefault(field, null);
            if (clickValueStr == null) {
                return 0;
            }

            String totalStr = doc.doc().attrs().getOrDefault(
                MtypeRequestProcessorFactory.MTYPE_TOTAL_SHOW, null);

            if (totalStr == null) {
                return 0;
            }

            double clickValue = Long.parseLong(clickValueStr);
            double total = Long.parseLong(totalStr);

            if (total == 0) {
                return 0;
            }

            return clickValue / total;
        }
    }
}
