package ru.yandex.msearch.proxy.api.async.mail.relevance.search.factors;

import ru.yandex.dbfields.MailIndexFields;
import ru.yandex.logger.PrefixedLogger;
import ru.yandex.msearch.proxy.api.async.mail.documents.Document;

import ru.yandex.msearch.proxy.api.async.mail.relevance.FactorGroup;
import ru.yandex.msearch.proxy.api.async.mail.relevance.RelevanceException;
import ru.yandex.msearch.proxy.api.async.mail.relevance.search.AbstractDocumentFactorFactory;
import ru.yandex.msearch.proxy.api.async.mail.relevance.search.factors.AbstractDocumentFactor;

import ru.yandex.parser.uri.CgiParams;

public class PlainReceiveDateFactorFactory extends AbstractDocumentFactorFactory {
    public PlainReceiveDateFactorFactory(final String name, final int index) {
        super(name, index);
    }

    @Override
    public FactorGroup<Document> create(
        final CgiParams params,
        final PrefixedLogger logger)
    {
        double ts = System.currentTimeMillis() / 1000.0;
        return new PlainReceivedDateFactor(index(), ts);
    }

    private static class PlainReceivedDateFactor extends AbstractDocumentFactor {
        private final double timestamp;

        public PlainReceivedDateFactor(
            final int index, final double timestamp)
        {
            super(index);
            this.timestamp = timestamp;
        }

        @Override
        public double calc (
            final Document doc,
            final String request)
            throws RelevanceException
        {
            String rcvDateStr =
                doc.doc().attrs().get(MailIndexFields.RECEIVED_DATE);

            if (rcvDateStr == null) {
                return 0;
            }

            long receiveDate = Long.parseLong(rcvDateStr);

            return (timestamp - receiveDate) / 3600.0;
        }
    }
}
