package ru.yandex.msearch.proxy.api.async.mail.relevance.search.factors;

import ru.yandex.json.parser.JsonException;
import ru.yandex.logger.PrefixedLogger;

import ru.yandex.msearch.proxy.api.async.mail.documents.Document;

import ru.yandex.msearch.proxy.api.async.mail.relevance.FactorGroup;
import ru.yandex.msearch.proxy.api.async.mail.relevance.search.factors.AbstractDocumentFactor;

import ru.yandex.msearch.proxy.api.async.mail.relevance.search.AbstractDocumentFactorFactory;
import ru.yandex.parser.uri.CgiParams;

public class RequestSubjectFactory extends AbstractDocumentFactorFactory {
    public RequestSubjectFactory(final String name, final int index) {
        super(name, index);
    }

    @Override
    public FactorGroup<Document> create(
        final CgiParams params,
        final PrefixedLogger logger)
    {
        return new RequestSubjectFactor(index());
    }

    private static class RequestSubjectFactor extends AbstractDocumentFactor {
        public RequestSubjectFactor(final int index) {
            super(index);
        }

        @Override
        public double calc(
            final Document doc,
            final String request)
            throws JsonException
        {
            String subject = doc.envelope().getOrNull("subject");
            if (subject == null) {
                subject =
                    doc.doc().attrs().getOrDefault("hdr_subject", null);
            }
            if (subject != null && subject.toLowerCase().contains(request)) {
                return 1;
            } else {
                return 0;
            }
        }
    }
}