package ru.yandex.msearch.proxy.api.async.mail.relevance.search.factors;

import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

import ru.yandex.http.util.BadRequestException;

import ru.yandex.json.parser.JsonException;

import ru.yandex.logger.PrefixedLogger;

import ru.yandex.msearch.proxy.api.async.mail.documents.Document;

import ru.yandex.msearch.proxy.api.async.mail.relevance.FactorGroup;
import ru.yandex.msearch.proxy.api.async.mail.relevance.RelevanceException;
import ru.yandex.msearch.proxy.api.async.mail.relevance.search.factors.AbstractDocumentFactor;
import ru.yandex.msearch.proxy.api.async.mail.relevance.search.AbstractDocumentFactorFactory;
import ru.yandex.parser.uri.CgiParams;

public class WeekdayFactorFactory extends AbstractDocumentFactorFactory {
    public WeekdayFactorFactory(final String name, final int index) {
        super(name, index);
    }

    @Override
    public FactorGroup<Document> create(
        final CgiParams params,
        final PrefixedLogger logger)
    {
        int tzoffset = 0;
        try {
            tzoffset = params.getInt("tzoffset", 0);
        } catch (BadRequestException bre) {
            logger.log(
                Level.WARNING,
                "Unable fetch tzoffset",
                bre);
        }

        if (Math.abs(tzoffset) > 24 * 60) {
            logger.warning("Invalid tzoffset " + tzoffset);
            tzoffset = 0;
        }

        tzoffset = (int) TimeUnit.MINUTES.toMillis(tzoffset);
        return new WeekdayFactor(index(), tzoffset);
    }

    private static class WeekdayFactor extends AbstractDocumentFactor {
        private final int value;

        public WeekdayFactor(final int index, final int tzoffset) {
            super(index);

            DateTime dateTime =
                new DateTime(DateTimeZone.forOffsetMillis(tzoffset));
            this.value = dateTime.dayOfWeek().get();
        }

        @Override
        public double calc(
            final Document doc,
            final String request)
            throws RelevanceException, JsonException
        {
            return value;
        }
    }
}
