package ru.yandex.msearch.proxy.api.async.mail.relevance.search.factors.email;

public abstract class AbstractEmailFactor {
    protected final int index;
    protected String request;
    protected double result;

    public AbstractEmailFactor(final int index) {
        this.index = index;
    }

    protected double noField() {
        return 0;
    }

    protected void init(final String request) {
        this.request = request;
        this.result = 0;
    }

    protected abstract boolean onEmail(
        final String local,
        final String domain,
        final String display);

    public int index() {
        return index;
    }

    public double result() {
        return result;
    }
}