package ru.yandex.msearch.proxy.api.async.mail.relevance.search.factors.email;

import ru.yandex.json.parser.JsonException;

import ru.yandex.logger.PrefixedLogger;

import ru.yandex.msearch.proxy.api.async.mail.documents.Document;

import ru.yandex.msearch.proxy.api.async.mail.relevance.search.AbstractDocumentFactorFactory;
import ru.yandex.msearch.proxy.api.async.mail.relevance.FactorGroup;

import ru.yandex.msearch.proxy.api.async.mail.relevance.search.factors.AbstractDocumentFactor;
import ru.yandex.parser.uri.CgiParams;

public class AnyEmailInRequestFactory extends AbstractDocumentFactorFactory {
    public AnyEmailInRequestFactory(final String name, final int index) {
        super(name, index);
    }

    @Override
    public FactorGroup create(
        final CgiParams params,
        final PrefixedLogger logger)
    {
        return new AnyEmailInRequestFactor(index());
    }

    public static class AnyEmailInRequestFactor
        extends AbstractDocumentFactor
    {
        public AnyEmailInRequestFactor(final int index) {
            super(index);
        }

        @Override
        public double calc(
            final Document doc,
            final String request)
            throws JsonException
        {
            if (request.contains("@")) {
                return 1;
            }

            return 0;
        }
    }
}