package ru.yandex.msearch.proxy.api.async.mail.relevance.search.factors.email;

import java.util.Locale;

public class BinaryDisplayInRequestFactory extends DisplayInRequestFactory {
    public BinaryDisplayInRequestFactory(final String name, final int index) {
        super(name, index);
    }

    @Override
    public AbstractEmailFactor create() {
        return new BinaryDisplayInReqquestFactor(index());
    }

    public static class BinaryDisplayInReqquestFactor
        extends DisplayInRequestFactor {

        public BinaryDisplayInReqquestFactor(final int index) {
            super(index);
        }

        @Override
        protected boolean onEmail(
            final String local,
            final String domain,
            final String display)
        {
            if (result > 0) {
                return true;
            }

            if (display != null
                && request.contains(display.toLowerCase(Locale.ENGLISH)))
            {
                result = 1;
            }

            return result > 0;
        }
    }
}
