package ru.yandex.msearch.proxy.api.async.mail.relevance.search.factors.email;

import java.util.Locale;

import ru.yandex.util.string.StringUtils;

public class BinaryEmailInRequestFactory extends EmailInRequestFactory {
    public BinaryEmailInRequestFactory(final String name, final int index) {
        super(name, index);
    }

    @Override
    public AbstractEmailFactor create() {
        return new BinaryEmailInRequestFactor(index());
    }

    public static class BinaryEmailInRequestFactor
        extends EmailInRequestFactor
    {
        public BinaryEmailInRequestFactor(final int index) {
            super(index);
        }

        @Override
        protected boolean onEmail(
            final String local,
            final String domain,
            final String display)
        {
            if (result > 0) {
                return true;
            }

            if (local != null && domain != null) {
                if (request.contains(
                    StringUtils.concat(local, '@', domain)
                        .toLowerCase(Locale.ENGLISH)))
                {
                    result = 1;
                }
            }

            return result > 0;
        }
    }
}
