package ru.yandex.msearch.proxy.api.async.mail.relevance.search.factors.email;

import java.util.Locale;

public class DisplayInRequestFactory extends EmailFactorFactory {
    public DisplayInRequestFactory(final String name, final int index) {
        super(name, index);
    }

    @Override
    public AbstractEmailFactor create() {
        return new DisplayInRequestFactor(index());
    }

    public static class DisplayInRequestFactor extends AbstractEmailFactor {
        private static final float PART_MULTIPLIER = 0.8f;

        public DisplayInRequestFactor(final int index) {
            super(index);
        }

        @Override
        protected boolean onEmail(
            final String local,
            final String domain,
            final String display)
        {
            if (result > 0) {
                return true;
            }

            String lDisplay = display.toLowerCase(Locale.ENGLISH);
            if (lDisplay != null && request.contains(lDisplay)) {
                result = 1;
            } else if (lDisplay.length() > request.length()) {
                String[] dSplit = lDisplay.trim().split("\\s+");
                if (dSplit.length > 0) {
                    int coincide = 0;
                    for (String word: dSplit) {
                        if (request.contains(word)) {
                            coincide += 1;
                        }
                    }

                    result = PART_MULTIPLIER * coincide / dSplit.length;
                }
            }

            return result > 0;
        }
    }
}
