package ru.yandex.msearch.proxy.api.async.mail.relevance.search.factors.email;

import java.util.ArrayList;
import java.util.List;

import ru.yandex.json.dom.JsonList;
import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.dom.JsonObject;

import ru.yandex.json.parser.JsonException;

import ru.yandex.logger.PrefixedLogger;
import ru.yandex.msearch.proxy.api.async.mail.documents.Document;

import ru.yandex.msearch.proxy.api.async.mail.relevance.AbstractFactorGroupFactory;
import ru.yandex.msearch.proxy.api.async.mail.relevance.FactorGroup;
import ru.yandex.msearch.proxy.api.async.mail.relevance.NormalizedFactorGroup;
import ru.yandex.msearch.proxy.api.async.mail.relevance.RelevanceException;

import ru.yandex.msearch.proxy.ora.wmi.fields.WmiField;
import ru.yandex.parser.uri.CgiParams;

public class EmailGroupFactory extends AbstractFactorGroupFactory {
    private final String wmiField;
    private final EmailFactorFactory[] factories;

    public EmailGroupFactory(
        final String name,
        final String wmiField,
        final EmailFactorFactory... factories)
    {
        super(name, factories);

        this.wmiField = wmiField;
        this.factories = factories;
    }

    @Override
    public FactorGroup create(
        final CgiParams params,
        final PrefixedLogger logger)
    {
        List<AbstractEmailFactor> factors = new ArrayList<>(factories.length);
        for (int i = 0; i < factories.length; i++) {
            factors.add(factories[i].create());
        }

        return new EmailGroup(wmiField, factors);
    }

    public static class EmailGroup implements NormalizedFactorGroup<Document> {
        private final String wmiField;
        private final List<AbstractEmailFactor> factors;

        public EmailGroup(
            final String wmiField,
            final List<AbstractEmailFactor> factors)
        {
            this.factors = factors;
            this.wmiField = wmiField;
        }

        @Override
        public void calc(
            final Document doc,
            final String request,
            final double[] res)
            throws RelevanceException, JsonException
        {
            JsonMap jsonMap = doc.envelope();
            JsonList fieldValue = jsonMap.getListOrNull(wmiField);
            if (fieldValue == null) {
                if (res != null) {
                    factors.forEach(f -> {
                        res[f.index()] = f.noField();
                    });
                }

                return;
            }

            factors.forEach(f -> f.init(request));

            for (JsonObject fromObj: fieldValue) {
                JsonMap fromMap = fromObj.asMap();
                if (fromMap == null) {
                    continue;
                }

                String local = fromMap.getOrNull(WmiField.EMAIL_LOCAL);
                String domain = fromMap.getOrNull(WmiField.EMAIL_DOMAIN);
                String display = fromMap.getOrNull(WmiField.EMAIL_DISPLAY);

                factors.forEach(f -> f.onEmail(local, domain, display));
            }

            if (res != null) {
                factors.forEach(f -> res[f.index()] = f.result());
            }
        }

    }
}
