package ru.yandex.msearch.proxy.api.async.mail.relevance.search.factors.email;

import java.util.Locale;

import ru.yandex.util.string.StringUtils;

public class EmailInRequestFactory extends EmailFactorFactory {
    public EmailInRequestFactory(final String name, final int index) {
        super(name, index);
    }

    @Override
    public AbstractEmailFactor create() {
        return new EmailInRequestFactor(index());
    }

    public static class EmailInRequestFactor extends AbstractEmailFactor {
        public EmailInRequestFactor(final int index) {
            super(index);
        }

        @Override
        protected boolean onEmail(
            final String local,
            final String domain,
            final String display)
        {
            if (result > 0) {
                return true;
            }

            if (local != null && domain != null) {
                if (request.contains(local.toLowerCase(Locale.ENGLISH))) {
                    if (request.contains(
                        StringUtils.concat(local, '@', domain)
                            .toLowerCase(Locale.ENGLISH)))
                    {
                        result = 1;
                    } else {
                        result = 0.5;
                    }
                }
            }

            return result > 0;
        }
    }
}