package ru.yandex.msearch.proxy.api.async.mail.result;

import java.util.Set;

import ru.yandex.json.writer.JsonWriter;

import ru.yandex.msearch.proxy.api.async.mail.RequestInfo;

public final class MailFieldsPrinterExtractor {
     public static MailFieldsPrinter extract(
         final JsonWriter writer,
         final RequestInfo requestInfo)
     {
         Set<String> get = requestInfo.get();
         MailFieldsPrinter printer;
         if (get == null) {
             if (requestInfo.highlighter() != null) {
                 printer = new HighlightingAllFieldsPrinter(
                     writer,
                     requestInfo.highlighter(),
                     requestInfo.options().request());
             } else {
                 printer = new AllFieldsPrinter(writer);
             }
         } else if (get.size() == 1) {
             printer =
                 new SingleFieldPrinter(writer, get.iterator().next());
         } else {
             printer = new SelectedFieldsPrinter(writer, get);
         }

         return printer;
     }
}
