package ru.yandex.msearch.proxy.api.async.mail.result;

import java.io.IOException;
import java.util.Set;


import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.writer.JsonWriter;

public class SelectedFieldsPrinter implements MailFieldsPrinter {
    private final JsonWriter writer;
    private final Set<String> names;

    public SelectedFieldsPrinter(
        final JsonWriter writer,
        final Set<String> names)
    {
        this.writer = writer;
        this.names = names;
    }

    @Override
    public void accept(final JsonMap doc) throws IOException {
        writer.startObject();
        for (String name: names) {
            String field = doc.getString(name, null);
            if (field != null) {
                writer.key(name);
                writer.value(field);
            }
        }
        writer.endObject();
    }
}
