package ru.yandex.msearch.proxy.api.async.mail.result;

import java.io.IOException;

import ru.yandex.json.parser.JsonException;
import ru.yandex.json.writer.JsonWriter;

import ru.yandex.msearch.proxy.api.async.mail.RequestInfo;
import ru.yandex.msearch.proxy.api.async.mail.documents.Documents;

import ru.yandex.msearch.proxy.api.async.mail.tabs.content.TabsSearchCallback.ThreadDocument;
import ru.yandex.msearch.proxy.api.async.mail.tabs.content.TabsSearchCallback.ThreadedDocuments;

public class ThreadedResultPrinter extends ResultPrinter {
    public ThreadedResultPrinter(final RequestInfo requestInfo) {
        super(requestInfo);
    }

    protected void writeDocuments(
        final JsonWriter writer,
        final MailFieldsPrinter printer,
        final Documents docs)
        throws IOException, JsonException
    {
        prologue(writer, docs);
        writeDocuments(printer, docs.sort());
        epilogue(writer, docs);
    }

    private void epilogue(
        final JsonWriter writer,
        final Documents documents)
        throws IOException
    {
        ThreadedDocuments docs = (ThreadedDocuments) documents;
        writer.endArray();

        writer.key("threadLabels");
        writer.startArray();

        int threshold = requestInfo.offset() + requestInfo.length();
        int pos = 0;

        for (ThreadDocument doc: docs.documents()) {
            if (pos >= threshold) {
                break;
            }

            if (pos >= requestInfo.offset()) {
                writer.value(doc.labels());
            }

            ++pos;
        }

        writer.endArray();
        writer.endObject();
    }
}
