package ru.yandex.msearch.proxy.api.async.mail.result;

import java.io.IOException;
import java.util.Iterator;

import ru.yandex.function.GenericConsumer;
import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.parser.JsonException;
import ru.yandex.json.writer.JsonWriter;
import ru.yandex.msearch.proxy.api.async.mail.RequestInfo;
import ru.yandex.msearch.proxy.api.async.mail.documents.Document;
import ru.yandex.msearch.proxy.api.async.mail.documents.Documents;
import ru.yandex.msearch.proxy.api.async.mail.documents.DocumentsGroup;
import ru.yandex.msearch.proxy.api.async.mail.result.ResultPrinter;

public class TopRelevantPrinter extends ResultPrinter {
    public TopRelevantPrinter(final RequestInfo requestInfo) {
        super(requestInfo);
    }

    @Override
    protected void writeDocuments(
        final JsonWriter writer,
        final MailFieldsPrinter printer,
        final Documents docs)
        throws IOException, JsonException
    {
        if (docs.relevant() <= 0) {
            super.writeDocuments(writer, printer, docs);
            return;
        }

        writer.startObject();
        writeDetails(writer, docs);

        int pos = 0;

        long threshold =
            Math.min(
                docs.relevant(),
                requestInfo.offset() + requestInfo.length());

        Iterator<DocumentsGroup> groupIterator = docs.iterator();
        Iterator<Document> docIterator = null;

        if (docs.relevant() > requestInfo.offset()) {
            writer.key("top-relevant");
            writer.startArray();

            while (pos < threshold && groupIterator.hasNext()) {
                DocumentsGroup group = groupIterator.next();
                docIterator = group.iterator();
                while (pos < threshold && docIterator.hasNext()) {
                    Document doc = docIterator.next();
                    if (pos >= requestInfo.offset()) {
                        printer.accept(doc.envelope());
                    }

                    ++pos;
                }
            }

            writer.endArray();

        }

        writer.key("envelopes");
        writer.startArray();
        threshold = requestInfo.offset() + requestInfo.length();

        if (docIterator != null) {
            while (pos < threshold && docIterator.hasNext()) {
                Document doc = docIterator.next();
                if (pos >= requestInfo.offset()) {
                    printer.accept(doc.envelope());
                }

                ++pos;
            }
        }

        while (pos < threshold && groupIterator.hasNext()) {
            for (Document doc: groupIterator.next()) {
                if (pos >= threshold) {
                    break;
                }

                if (pos >= requestInfo.offset()) {
                    printer.accept(doc.envelope());
                }

                ++pos;
            }
        }

        epilogue(writer);
    }
}
