package ru.yandex.msearch.proxy.api.async.mail.rules;

import java.util.function.Function;

import org.apache.http.HttpHost;
import org.apache.http.nio.protocol.HttpAsyncRequestProducer;
import ru.yandex.http.util.nio.client.AsyncClient;
import ru.yandex.msearch.proxy.api.async.mail.SearchRequest;
import ru.yandex.msearch.proxy.api.async.mail.SearchSession;
import ru.yandex.msearch.proxy.api.async.mail.searcher.PlainSearcher;
import ru.yandex.search.result.SearchResult;
import ru.yandex.stater.RequestsStater;

public abstract class AbstractPlainSearchCallback
    extends AbstractSessionCallback<SearchResult>
{
    protected final AsyncClient searchClient;
    protected final RequestsStater stater;
    protected final SearchRequest request;
    protected long start = 0L;

    public AbstractPlainSearchCallback(
        final SearchSession session,
        final RuleContext context,
        final SearchRequest request)
    {
        super(session);

        this.request = request;
        stater = context.server().backendsRequestsStater();
        searchClient = context.server().searchClient().adjust(
            session.httpSession().context());
    }

    protected abstract Function<? super HttpHost, ? extends HttpAsyncRequestProducer> nextRequest();

    protected abstract PlainSearcher searcher();

    public void sendNextRequest() {
        start = System.currentTimeMillis();

        searcher().search(nextRequest(), this);
    }
}
