package ru.yandex.msearch.proxy.api.async.mail.rules;

import org.apache.http.HttpException;
import ru.yandex.msearch.proxy.api.async.mail.SearchRequest;
import ru.yandex.msearch.proxy.api.async.mail.SearchSession;

public abstract class AbstractPlainSearchRule implements SearchRule {
    protected final RuleContext context;

    public AbstractPlainSearchRule(final RuleContext context) {
        this.context = context;
    }

    protected abstract AbstractPlainSearchCallback createCallback(
        final SearchSession session,
        final SearchRequest request)
        throws HttpException;

    protected abstract SearchRequest request(
        final SearchSession session)
        throws HttpException;

    @Override
    public void execute(final SearchSession session) throws HttpException {
        createCallback(session, request(session)).sendNextRequest();
    }
}
