package ru.yandex.msearch.proxy.api.async.mail.rules;

import org.apache.http.concurrent.FutureCallback;

import ru.yandex.msearch.proxy.api.async.mail.SearchSession;

public abstract class AbstractSessionCallback<T> implements FutureCallback<T> {
    protected final SearchSession session;
    protected boolean done = false;

    public AbstractSessionCallback(final SearchSession session) {
        this.session = session;
    }

    @Override
    public synchronized void failed(final Exception e) {
        if (!done) {
            done = true;
            session.callback().failed(e);
        }
    }

    @Override
    public synchronized void cancelled() {
        if (!done) {
            done = true;
            session.callback().cancelled();
        }
    }
}

