package ru.yandex.msearch.proxy.api.async.mail.rules;

import java.util.List;

import org.apache.http.HttpException;

import ru.yandex.blackbox.BlackboxUserinfo;

import ru.yandex.http.util.BadRequestException;

import ru.yandex.msearch.proxy.api.async.ProxyParams;
import ru.yandex.msearch.proxy.api.async.mail.SearchSession;

public class CheckCorpUidRule implements SearchRule {
    private final SearchRule next;

    public CheckCorpUidRule(final SearchRule next) {
        this.next = next;
    }

    @Override
    public void execute(final SearchSession session) throws HttpException {
        long uid = session.params().getLong(ProxyParams.UID);
        if (!BlackboxUserinfo.corp(uid)) {
            throw new BadRequestException("UID: " + uid + ", is not valid "
                + " yandex-team user id");
        }
        next.execute(session);
    }
}

