package ru.yandex.msearch.proxy.api.async.mail.rules;

import java.util.Comparator;
import java.util.function.Function;

import ru.yandex.msearch.proxy.api.async.mail.documents.BasicDocuments;
import ru.yandex.msearch.proxy.api.async.mail.documents.Document;
import ru.yandex.msearch.proxy.api.async.mail.documents.Documents;
import ru.yandex.msearch.proxy.api.async.mail.RequestInfo;
import ru.yandex.msearch.proxy.api.async.mail.SearchRequest;

public class Collector {
    protected final RequestInfo requestInfo;
    protected final SearchRequest request;
    protected final Documents documents;
    private volatile int nextOffset;
    private volatile int requests;

    public Collector(
        final RequestInfo requestInfo,
        final SearchRequest request,
        final Function<Comparator<Document>, Documents> documentsFactory)
    {
        this.requestInfo = requestInfo;
        this.request = request;
        documents = documentsFactory.apply(request.sort().comparator());
        nextOffset = 0;
    }

    public Documents documents() {
        return documents;
    }

    public int length() {
        return Math.max(
            request.filterSearchConfig().batchSize(),
            (needDocuments() - documents.size())
                * request.requestedResultsMultipier());
    }

    public int needDocuments() {
        return requestInfo.offset() + requestInfo.length();
    }

    public boolean needMoreDocuments() {
        return documents.size() < needDocuments();
    }

    public int requests() {
        return requests;
    }

    public String nextRequest() {
        StringBuilder sb = new StringBuilder(request.luceneRequest());
        sb.append("&offset=");
        sb.append(nextOffset);
        sb.append("&length=");
        int length = length();
        sb.append(length);
        nextOffset += length;
        requests += 1;
        return new String(sb);
    }
}

