package ru.yandex.msearch.proxy.api.async.mail.rules;

import java.util.Map;

import org.apache.http.HttpStatus;

import ru.yandex.json.parser.JsonException;
import ru.yandex.json.dom.JsonList;
import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.writer.JsonType;
import ru.yandex.msearch.proxy.api.async.mail.SearchSession;
import ru.yandex.search.result.SearchDocument;
import ru.yandex.util.string.StringUtils;
import ru.yandex.stater.RequestInfo;
import ru.yandex.util.timesource.TimeSource;

public class FilterSearchCallback
    extends AbstractSessionCallback<JsonObject>
{
    private final long startTime = System.currentTimeMillis();
    private final Map<String, SearchDocument> docs;
    private final FilterPlainSearchCallback callback;

    public FilterSearchCallback(
        final SearchSession session,
        final Map<String, SearchDocument> docs,
        final FilterPlainSearchCallback callback)
    {
        super(session);
        this.docs = docs;
        this.callback = callback;
    }

    @Override
    public synchronized void completed(final JsonObject root) {
        callback.filterSearchResponsesStater().accept(
            new RequestInfo(
                TimeSource.INSTANCE.currentTimeMillis(),
                HttpStatus.SC_OK,
                startTime,
                startTime,
                0L,
                0L));
        if (done) {
            return;
        }
        StringBuilder mids = StringUtils.join(
            docs.keySet(),
            ',',
            "After filtration of mids ",
            0);
        mids.append(" the following mids left: ");
        try {
            JsonList envelopes = root.get("envelopes").asList();
            for (int i = 0; i < envelopes.size(); ++i) {
                JsonMap envelope = envelopes.get(i).asMap();
                String mid = envelope.getString("mid");
                mids.append(mid);
                mids.append(',');
                SearchDocument doc = docs.get(mid);
                if (doc == null) {
                    throw new JsonException(
                        "At envelope #" + i + " unexpected mid found: " + mid);
                }
                callback.document(mid, doc, envelope);
            }

            int filteredOut = docs.size() - envelopes.size();

            if (filteredOut > 0) {
                callback.reduceTotalDocs(filteredOut);
            }
        } catch (JsonException e) {
            failed(new JsonException(
                "Failed to parse: " + JsonType.NORMAL.toString(root), e));
            return;
        }
        mids.setLength(mids.length() - 1);
        session.httpSession().logger().fine(new String(mids));
        done = true;
        callback.subrequestDone();
    }
}

