package ru.yandex.msearch.proxy.api.async.mail.rules;

import java.util.regex.Pattern;

import org.apache.http.HttpException;
import org.apache.http.HttpStatus;

import ru.yandex.http.util.ServerException;

import ru.yandex.msearch.proxy.api.async.mail.SearchSession;

public class ForbiddenRequestsRule implements SearchRule {
    private final SearchRule next;
    private final Pattern pattern;

    public ForbiddenRequestsRule(
        final SearchRule next,
        final Pattern pattern)
    {
        this.next = next;
        this.pattern = pattern;
    }

    @Override
    public void execute(final SearchSession session) throws HttpException {
        if (session.params().getBoolean("imap", false)) {
            String text = session.params().getString("request", null);
            if (text != null && pattern.matcher(text).matches()) {
                session.httpSession().logger().warning(
                    "Request banned: " + text);
                throw new ServerException(
                    HttpStatus.SC_FORBIDDEN,
                    "Request '" + text + "' is forbidden by " + pattern);
            }
        }
        next.execute(session);
    }
}

