package ru.yandex.msearch.proxy.api.async.mail.rules;

import org.apache.http.HttpException;

import ru.yandex.msearch.proxy.api.async.mail.SearchSession;

public class ImapSearchRule implements SearchRule {
    public static final String LOWERCASE_EXPANDED_TERMS =
        "lowercase-expanded-terms";

    private final SearchRule next;

    public ImapSearchRule(final SearchRule next) {
        this.next = next;
    }

    @Override
    public void execute(final SearchSession session) throws HttpException {
        String lowercaseExpandedTerms =
            session.params().getString(LOWERCASE_EXPANDED_TERMS, null);
        if (lowercaseExpandedTerms == null) {
            SearchSession sessionCopy = session.copy();
            sessionCopy.params().add(LOWERCASE_EXPANDED_TERMS, "true");
            next.execute(sessionCopy);
        } else {
            next.execute(session);
        }
    }
}

