package ru.yandex.msearch.proxy.api.async.mail.rules;


import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

import org.joda.time.DateTimeZone;

import ru.yandex.http.util.BadRequestException;

import ru.yandex.msearch.proxy.AsyncHttpServer;
import ru.yandex.msearch.proxy.Synonyms;
import ru.yandex.msearch.proxy.api.mail.rules.MailSearchRule;

import ru.yandex.msearch.proxy.mail.SearchFilter;
import ru.yandex.parser.uri.CgiParams;

public class LuceneQueryContext {
    private static final DateTimeZone MSK_TIMEZONE =
        DateTimeZone.forID("Europe/Moscow");

    private final StringBuilder request = new StringBuilder();
    private final String selectAll;
    private final DateTimeZone timezone;
    private final Collection<String> defaultScope;
    private final Map<String, SearchFilter> filters;
    private final Synonyms synonyms;
    private boolean trivial = true;

    public LuceneQueryContext(
        final String selectAll,
        final CgiParams params,
        final AsyncHttpServer server)
        throws BadRequestException
    {
        this.selectAll = selectAll;
        timezone = params.get(
            "tzoffset",
            MSK_TIMEZONE,
            x -> DateTimeZone.forOffsetMillis(Integer.parseInt(x) * 60000));
        List<String> scopes = RewriteRequestRule.scope(params, null);
        if (scopes != null) {
            this.defaultScope = new LinkedHashSet<>();
            for (String scope: scopes) {
                defaultScope.addAll(
                    RewriteRequestRule.scopeFor(scope, params));
            }
        } else {
            this.defaultScope = MailSearchRule.DEFAULT_SCOPE;
        }

        filters = server.config().filtersConfig().filters();
        synonyms = server.synonyms();
    }

    public StringBuilder request() {
        return request;
    }

    public String selectAll() {
        return selectAll;
    }

    public DateTimeZone timezone() {
        return timezone;
    }

    public Collection<String> defaultScope() {
        return defaultScope;
    }

    public Map<String, SearchFilter> filters() {
        return filters;
    }

    public Synonyms synonyms() {
        return synonyms;
    }

    public boolean trivial() {
        return trivial;
    }

    public void nonTrivial() {
        trivial = false;
    }
}

