package ru.yandex.msearch.proxy.api.async.mail.rules;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

import org.apache.http.HttpException;

import ru.yandex.http.util.BadRequestException;
import ru.yandex.http.util.DoubleFutureCallback;

import ru.yandex.json.dom.JsonBoolean;

import ru.yandex.msearch.proxy.api.async.ProxyParams;
import ru.yandex.msearch.proxy.api.async.mail.RequestInfo;
import ru.yandex.msearch.proxy.api.async.mail.SearchRequest;
import ru.yandex.msearch.proxy.api.async.mail.SearchSession;

import ru.yandex.msearch.proxy.api.async.mail.documents.BasicDocument;
import ru.yandex.msearch.proxy.api.async.mail.documents.BasicDocuments;
import ru.yandex.msearch.proxy.api.async.mail.documents.Document;
import ru.yandex.msearch.proxy.api.async.mail.documents.Documents;
import ru.yandex.msearch.proxy.api.async.mail.documents.DocumentsGroup;

import ru.yandex.parser.uri.CgiParams;

import ru.yandex.util.string.StringUtils;

public class MailThreadsListRule implements SearchRule {
    private static final String INFINITY = Integer.toString(Integer.MAX_VALUE);

    private final SearchRule searchRule;
    private final SearchRule plainSearchRule;

    public MailThreadsListRule(
        final SearchRule searchRule,
        final SearchRule plainSearchRule)
    {
        this.searchRule = searchRule;
        this.plainSearchRule = plainSearchRule;
    }

    private static void copy(
        final CgiParams from,
        final CgiParams to,
        final String name)
    {
        to.replace(name, from.getString(name, null));
    }

    @Override
    public void execute(final SearchSession session) throws HttpException {
        SearchSession thread = session.copy();
        thread.params().clear();
        thread.params().add(
            "request",
            new String(
                StringUtils.join(
                    session.params().getAll("thread_id"),
                    ' ',
                    "thread_id:(",
                    1).append(')')));
        copy(session.params(), thread.params(), ProxyParams.MDB);
        copy(session.params(), thread.params(), ProxyParams.UID);
        copy(session.params(), thread.params(), ProxyParams.SUID);
        copy(session.params(), thread.params(), "folder_set");
        copy(session.params(), thread.params(), "original-suid");
        copy(session.params(), thread.params(), "order");
        copy(session.params(), thread.params(), "failover-delay");
        DoubleFutureCallback<Documents, Documents> callback =
            new DoubleFutureCallback<>(
                new MailThreadsListCallback(
                    session,
                    searchRule,
                    plainSearchRule));
        searchRule.execute(session.withCallback(callback.first()));
        plainSearchRule.execute(thread.withCallback(callback.second()));
    }

    public static class MailThreadsListCallback
        extends AbstractSessionCallback<Map.Entry<Documents, Documents>>
    {
        private final SearchRule searchRule;
        private final SearchRule plainSearchRule;

        public MailThreadsListCallback(
            final SearchSession session,
            final SearchRule searchRule,
            final SearchRule plainSearchRule)
            throws BadRequestException
        {
            super(session);
            this.searchRule = searchRule;
            this.plainSearchRule = plainSearchRule;
        }

        public void completed(final Map.Entry<Documents, Documents> result) {
            Documents searchHits = result.getKey();
            Set<String> hitsIds = new HashSet<>(searchHits.size() << 1);
            for (DocumentsGroup group: searchHits) {
                for (Document doc: group) {
                    hitsIds.add(doc.id());
                }
            }
            Documents fullThread = result.getValue();
            for (DocumentsGroup group: fullThread) {
                for (Document doc: group) {
                    if (hitsIds.contains(doc.id())) {
                        doc.envelope().put("searchHit", JsonBoolean.TRUE);
                    }
                }
            }
            session.callback().completed(fullThread);
        }
    }
}

