package ru.yandex.msearch.proxy.api.async.mail.rules;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import ru.yandex.http.util.BadRequestException;
import ru.yandex.json.dom.JsonLong;
import ru.yandex.json.dom.JsonMap;

import ru.yandex.json.parser.JsonException;

import ru.yandex.msearch.proxy.api.async.mail.SearchRequest;
import ru.yandex.msearch.proxy.api.async.mail.SearchSession;

import ru.yandex.msearch.proxy.api.async.mail.documents.BasicDocument;
import ru.yandex.msearch.proxy.api.async.mail.documents.BasicDocuments;
import ru.yandex.msearch.proxy.api.async.mail.documents.Document;
import ru.yandex.msearch.proxy.api.async.mail.documents.Documents;
import ru.yandex.msearch.proxy.api.async.mail.documents.DocumentsGroup;

import ru.yandex.search.result.BasicSearchResult;
import ru.yandex.search.result.SearchDocument;
import ru.yandex.search.result.SearchResult;

public class MailThreadsSearchCallback extends FilterPlainSearchCallback {
    public MailThreadsSearchCallback(
        final SearchSession session,
        final RuleContext context,
        final SearchRequest request)
        throws BadRequestException
    {
        super(session, context, request);
    }

    private void addUniqueMid(
        final List<SearchDocument> docs,
        final Set<String> mids,
        final SearchDocument doc)
    {
        if (mids.add(doc.attrs().get("mid"))) {
            docs.add(doc);
        }
    }

    @Override
    protected int sendSubrequests(final SearchResult result) {
        // Extract all mids merged by group=thread_id, so we can filter them
        // This is the deduplicating collection
        Set<String> mids = new HashSet<>();
        // Do not add documents with empty mid
        mids.add(null);
        List<SearchDocument> docs = new ArrayList<>();
        for (SearchDocument hit: result.hitsArray()) {
            addUniqueMid(docs, mids, hit);
            for (SearchDocument mergedDoc: hit.mergedDocs()) {
                addUniqueMid(docs, mids, mergedDoc);
            }
            hit.mergedDocs().clear();
        }
        return super.sendSubrequests(new BasicSearchResult(docs, 0));
    }

    @Override
    protected Documents buildResultDocuments() {
        Documents docs =
            new BasicDocuments(collector.documents().comparator());
        docs.total(collector.documents().total());

        // From each group add only best element to result.
        for (DocumentsGroup group: collector.documents()) {
            Document doc = group.best();
            doc.envelope().put(
                "threadSize",
                JsonLong.valueOf(uniqueMids(group)));
            docs.add(group.id(), doc);
        }
        return docs;
    }

    private int uniqueMids(final DocumentsGroup docs) {
        Set<String> mids = new HashSet<>();
        for (Document doc: docs) {
            mids.add(doc.id());
        }
        return mids.size();
    }

    @Override
    public void document(
        final String mid,
        final SearchDocument doc,
        final JsonMap envelope)
        throws JsonException
    {
        String threadId = envelope.getString("threadId");
        String group;
        if (threadId.isEmpty()) {
            group = mid;
        } else {
            group = threadId;
        }
        Document groupDoc = new BasicDocument(mid, doc, envelope);
        synchronized (collector) {
            collector.documents().add(group, groupDoc);
        }
    }
}

