package ru.yandex.msearch.proxy.api.async.mail.rules;

import java.util.function.Function;

import org.apache.http.HttpHost;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.nio.protocol.HttpAsyncRequestProducer;
import ru.yandex.msearch.proxy.api.async.mail.searcher.PlainSearcher;
import ru.yandex.search.result.SearchResult;

public interface PlainCallback extends FutureCallback<SearchResult> {
    Function<? super HttpHost, ? extends HttpAsyncRequestProducer> nextRequest();

    PlainSearcher<SearchResult> searcher();

    default void sendNextRequest() {
        searcher().search(nextRequest(), this);
    }
}
