package ru.yandex.msearch.proxy.api.async.mail.rules;

import org.apache.http.HttpException;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.msearch.proxy.api.async.mail.SearchRequest;
import ru.yandex.msearch.proxy.api.async.mail.SearchSession;
import ru.yandex.msearch.proxy.api.async.mail.SingleFieldSortOrder;

public class PlainSearchRule extends AbstractPlainSearchRule {
    public PlainSearchRule(final RuleContext context) {
        super(context);
    }

    protected AbstractPlainSearchCallback createCallback(
        final SearchSession session,
        final SearchRequest request)
        throws BadRequestException
    {
        return new FilterPlainSearchCallback(session, context, request);
    }

    protected SearchRequest request(
        final SearchSession session)
        throws HttpException
    {
        return new SearchRequest(
            session.params().getEnum(
                SingleFieldSortOrder.class,
                "order",
                SingleFieldSortOrder.DEFAULT),
            session,
            context);
    }
}

