package ru.yandex.msearch.proxy.api.async.mail.rules;

import java.util.List;

import org.apache.http.HttpException;

import ru.yandex.msearch.proxy.api.async.mail.SearchSession;
import ru.yandex.msearch.proxy.api.async.mail.documents.Documents;
import ru.yandex.msearch.proxy.api.mail.rules.MailSearchRule;

import ru.yandex.util.string.StringUtils;

public class PureSearchRule implements SearchRule {
    public static final String PURE_SEARCH = "pure-search";

    private static final String SCOPE = "scope";
    private static final String PURE_SCOPE =
        StringUtils.join(MailSearchRule.PURE_SCOPE, ',');

    private final SearchRule next;

    public PureSearchRule(final SearchRule next) {
        this.next = next;
    }

    @Override
    public void execute(final SearchSession session) throws HttpException {
        boolean pure = session.params().getBoolean(PURE_SEARCH, true);
        if (pure) {
            List<String> scope =
                RewriteRequestRule.scope(session.params(), null);
            if (scope == null) {
                SearchSession copy = session.copy();
                copy.params().replace(SCOPE, PURE_SCOPE);
                next.execute(
                    copy.withCallback(new PureCallback(session, next)));
            } else if (scope.size() == 1 && "body_text".equals(scope.get(0))) {
                SearchSession copy = session.copy();
                copy.params().replace(SCOPE, "pure_body");
                next.execute(
                    copy.withCallback(new PureCallback(session, this)));
            } else {
                next.execute(session);
            }
        } else {
            next.execute(session);
        }
    }

    private static class PureCallback
        extends AbstractSessionCallback<Documents>
    {
        private final SearchSession session;
        private final SearchRule next;

        public PureCallback(
            final SearchSession session,
            final SearchRule next)
        {
            super(session);
            this.session = session;
            this.next = next;
        }

        @Override
        public synchronized void completed(final Documents documents) {
            if (!done) {
                done = true;
                if (documents.size() == 0) {
                    session.httpSession().logger().info(
                        "No documents found for pure search, trying to search "
                        + "in quotations and attachments");
                    SearchSession copy = session.copy();
                    copy.params().replace(PURE_SEARCH, "false");
                    try {
                        next.execute(copy);
                    } catch (HttpException e) {
                        session.callback().failed(e);
                    }
                } else {
                    session.requestInfo().options().pure(true);
                    session.callback().completed(documents);
                }
            }
        }
    }
}

