package ru.yandex.msearch.proxy.api.async.mail.rules;

import java.util.List;

import org.apache.http.HttpException;

import ru.yandex.blackbox.BlackboxClient;
import ru.yandex.blackbox.BlackboxDbfield;
import ru.yandex.blackbox.BlackboxUserinfo;
import ru.yandex.blackbox.BlackboxUserinfoRequest;

import ru.yandex.http.util.YandexHeaders;

import ru.yandex.msearch.proxy.AsyncHttpServer;

import ru.yandex.msearch.proxy.api.async.ProxyParams;
import ru.yandex.msearch.proxy.api.async.mail.SearchSession;

public class ResolveUidRule implements SearchRule {
    private final SearchRule next;
    private final AsyncHttpServer server;

    public ResolveUidRule(
        final SearchRule next,
        final AsyncHttpServer server)
    {
        this.next = next;
        this.server = server;
    }

    @Override
    public void execute(final SearchSession session) throws HttpException {
        Long uidBoxed = session.params().getLong(ProxyParams.UID, null);
        if (uidBoxed != null
            && (session.params().getString(ProxyParams.SUID, null) == null
                || session.params().getString(ProxyParams.MDB, null) == null))
        {
            long uid = uidBoxed;
            BlackboxClient client =
                server.blackboxClient(uid, session.httpSession().context());
            client.userinfo(
                new BlackboxUserinfoRequest(uid)
                    .requiredDbfields(
                        BlackboxDbfield.SUID,
                        BlackboxDbfield.MDB)
                    .addHeader(
                        YandexHeaders.X_YA_SERVICE_TICKET,
                        server.blackboxTvm2Ticket(uid)),
                session.httpSession().requestsListener()
                    .createContextGeneratorFor(client),
                new BlackboxCallback(session, next));
        } else {
            next.execute(session);
        }
    }

    private static class BlackboxCallback
        extends AbstractSessionCallback<List<BlackboxUserinfo>>
    {
        private final SearchRule next;

        public BlackboxCallback(
            final SearchSession session,
            final SearchRule next)
        {
            super(session);
            this.next = next;
        }

        @Override
        public synchronized void completed(
            final List<BlackboxUserinfo> userinfos)
        {
            if (done) {
                return;
            }
            done = true;
            SearchSession session = this.session.copy();
            session.params().replace(
                ProxyParams.SUID,
                userinfos.get(0).dbfields().get(BlackboxDbfield.SUID));
            session.params().replace(
                ProxyParams.MDB,
                userinfos.get(0).dbfields().get(BlackboxDbfield.MDB));
            try {
                next.execute(session);
            } catch (HttpException e) {
                session.callback().failed(e);
            }
        }
    }
}

