package ru.yandex.msearch.proxy.api.async.mail.rules;

import org.apache.http.HttpException;

import ru.yandex.msearch.proxy.api.async.mail.SearchSession;

import ru.yandex.parser.uri.CgiParams;

public class RewriteScopeRule implements SearchRule {
    private final SearchRule next;

    public RewriteScopeRule(final SearchRule next) {
        this.next = next;
    }

    @Override
    public void execute(final SearchSession session) throws HttpException {
        CgiParams params = session.params();
        String scope = params.getString("scope", "");
        String request = params.getString("request", "");
        if (scope.isEmpty() || request.isEmpty()) {
            next.execute(session);
        } else {
            SearchSession sessionCopy = session.copy();
            params = sessionCopy.params();
            if (scope.startsWith("subject_thread_")) {
                String[] split = scope.split("_");
                params.replace("thread_id", split[split.length - 1]);
                params.replace("threads_list", "0");
                params.remove("scope");
                next.execute(sessionCopy);
                return;
            }

            switch (scope) {
                case "history":
                    params.replace("imap", "1");
                    StringBuilder sb = new StringBuilder();
                    for (String email: request.split(" ")) {
                        if (sb.length() > 0) {
                            sb.append(" OR ");
                        }
                        sb.append("hdr_from:\"");
                        sb.append(email);
                        sb.append("\" OR hdr_to:\"");
                        sb.append(email);
                        sb.append('"');
                    }
                    params.replace("request", new String(sb));
                    break;
                case "rpopid":
                    params.replace("imap", "1");
                    params.replace("request",
                        "headers:\"_$XHIDENX$_x-yandex-rpop-id: " + request
                        + "\" OR headers:\"x-yandex-rpop-id: " + request
                        + '"');
                    params.remove("scope");
                    break;
                case "rpopinfo":
                    params.replace("imap", "1");
                    params.replace(
                        "request",
                        "headers:\"_$XHIDENX$_x-yandex-rpop-info: " + request
                        + "\" OR headers:\"x-yandex-rpop-info: " + request
                        + '"');
                    params.remove("scope");
                    break;
                case "imap":
                    params.replace("imap", "1");
                    params.replace(
                        "request",
                        request.replace("*", "").replace("?", ""));
                    params.remove("scope");
                    break;
                default:
                    next.execute(session);
                    return;
            }
            next.execute(sessionCopy);
        }
    }
}

