package ru.yandex.msearch.proxy.api.async.mail.rules;

import java.util.Comparator;
import java.util.function.Function;

import ru.yandex.function.GenericFunction;

import ru.yandex.http.util.BadRequestException;

import ru.yandex.msearch.proxy.AsyncHttpServer;
import ru.yandex.msearch.proxy.api.async.mail.SearchAttributes;
import ru.yandex.msearch.proxy.api.async.mail.documents.Document;
import ru.yandex.msearch.proxy.api.async.mail.documents.Documents;

import ru.yandex.parser.uri.CgiParams;

public class RuleContext {
    private final AsyncHttpServer server;
    private final Function<Comparator<Document>, Documents> documentsFactory;
    private final GenericFunction<
        CgiParams,
        SearchAttributes,
        BadRequestException>
        searchAttributesFactory;

    public RuleContext(
        final AsyncHttpServer server,
        final Function<Comparator<Document>, Documents> documentsFactory,
        final GenericFunction<CgiParams, SearchAttributes, BadRequestException>
        searchAttributesFactory)
    {
        this.server = server;
        this.documentsFactory = documentsFactory;
        this.searchAttributesFactory = searchAttributesFactory;
    }

    public AsyncHttpServer server() {
        return server;
    }

    public Function<Comparator<Document>, Documents> documentsFactory() {
        return documentsFactory;
    }

    public GenericFunction<CgiParams, SearchAttributes, BadRequestException>
        searchAttributesFactory()
    {
        return searchAttributesFactory;
    }
}

