package ru.yandex.msearch.proxy.api.async.mail.rules;

import org.apache.http.HttpException;

import ru.yandex.msearch.proxy.api.async.mail.SearchSession;

public class SelectSearchRule implements SearchRule {
    private final SearchRule imapSearchRule;
    private final SearchRule mailSearchRule;
    private final SearchRule mailGroupsSearchRule;
    private final SearchRule mailThreadsSearchRule;
    private final SearchRule mailThreadsListRule;

    public SelectSearchRule(
        final SearchRule imapSearchRule,
        final SearchRule mailSearchRule,
        final SearchRule mailGroupsSearchRule,
        final SearchRule mailThreadsListRule,
        final SearchRule mailThreadsSearchRule)
    {
        this.imapSearchRule = imapSearchRule;
        this.mailSearchRule = mailSearchRule;
        this.mailGroupsSearchRule = mailGroupsSearchRule;
        this.mailThreadsListRule = mailThreadsListRule;
        this.mailThreadsSearchRule = mailThreadsSearchRule;
    }

    @Override
    public void execute(final SearchSession session) throws HttpException {
        if (session.params().getBoolean("imap", false)) {
            imapSearchRule.execute(session);
        } else if ("rlv".equals(session.params().getString("order", null))) {
            mailGroupsSearchRule.execute(session);
        } else if (session.params().getBoolean("threads_list", true)
            && session.params().getString("thread_id", null) != null)
        {
            mailThreadsListRule.execute(session);
        } else if (session.params().getBoolean("threaded", false)) {
            mailThreadsSearchRule.execute(session);
        } else {
            mailSearchRule.execute(session);
        }
    }
}
