package ru.yandex.msearch.proxy.api.async.mail.searcher;

import java.util.Collections;
import java.util.List;
import java.util.function.Function;

import org.apache.http.HttpHost;
import org.apache.http.nio.protocol.HttpAsyncRequestProducer;
import org.apache.http.protocol.HttpCoreContext;

import ru.yandex.client.producer.ProducerClient;
import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.http.util.HttpHostParser;
import ru.yandex.http.util.nio.client.AsyncClient;
import ru.yandex.http.util.nio.client.RequestsListener;
import ru.yandex.logger.PrefixedLogger;
import ru.yandex.msearch.proxy.api.async.Session;
import ru.yandex.parser.searchmap.SearchMap;
import ru.yandex.parser.searchmap.User;
import ru.yandex.parser.uri.CgiParams;

public abstract class AbstractPlainSearcher<T> implements PlainSearcher<T> {
    protected final AsyncClient searchClient;
    protected final ProducerClient producerClient;
    protected final PrefixedLogger logger;
    protected final RequestsListener listener;
    protected final HttpCoreContext context;
    protected final HttpHost forcedHost;
    protected final ProxySession proxySession;

    public AbstractPlainSearcher(
        final Session session,
        final CgiParams params,
        final AsyncClient searchClient,
        final ProducerClient producerClient)
        throws BadRequestException
    {
        this.proxySession = session;
        this.searchClient = searchClient.adjust(session.context());
        if (producerClient == null) {
            this.producerClient = null;
        } else {
            this.producerClient = producerClient.adjust(session.context());
        }

        this.logger = session.logger();
        this.listener = session.requestsListener();
        this.context = session.context();
        if (params != null) {
            this.forcedHost =
                params.get(
                    "backendHost",
                    null,
                    HttpHostParser.INSTANCE);
        } else {
            this.forcedHost = null;
        }
    }

    public AbstractPlainSearcher(
        final ProxySession session,
        final AsyncClient searchClient,
        final ProducerClient producerClient)
        throws BadRequestException
    {
        this.proxySession = session;
        this.searchClient = searchClient.adjust(session.context());
        if (producerClient == null) {
            this.producerClient = null;
        } else {
            this.producerClient = producerClient.adjust(session.context());
        }

        this.logger = session.logger();
        this.listener = session.listener();
        this.context = session.context();
        this.forcedHost =
            session.params().get(
                "backendHost",
                null,
                HttpHostParser.INSTANCE);
    }

    protected ProxySession proxySession() {
        return proxySession;
    }

    protected List<HttpHost> hosts(
        final SearchMap searchMap,
        final User user)
    {
        if (forcedHost == null) {
            return searchMap.searchHosts(user);
        }

        return Collections.singletonList(forcedHost);
    }

    protected PrefixedLogger logger() {
        return logger;
    }

    protected RequestsListener listener() {
        return listener;
    }

    public HttpCoreContext context() {
        return context;
    }
}
