package ru.yandex.msearch.proxy.api.async.mail.searcher;

import java.util.concurrent.atomic.AtomicInteger;

import org.apache.http.HttpStatus;

import org.apache.http.concurrent.FutureCallback;

import ru.yandex.http.util.RequestErrorType;
import ru.yandex.http.util.ServerException;

import ru.yandex.logger.PrefixedLogger;

import ru.yandex.search.result.SearchResult;

public class StrictPositionSearcherCallback
    implements FutureCallback<SearchResult>
{
    protected final FutureCallback<SearchResult> callback;
    protected final AtomicInteger requests;
    protected final PrefixedLogger logger;
    protected final long position;

    public StrictPositionSearcherCallback(
        final FutureCallback<SearchResult> callback,
        final PrefixedLogger logger,
        final long position,
        final int requests)
    {
        this.position = position;
        this.callback = callback;
        this.logger = logger;
        this.requests = new AtomicInteger(requests);
    }

    @Override
    public void completed(final SearchResult result) {
        if (requests.get() <= 0) {
            return;
        }

        if (result.zooQueueId() >= position) {
            if (requests.getAndSet(0) > 0) {
                callback.completed(result);
            }

            return;
        }

        if (requests.decrementAndGet() == 0) {
            callback.failed(new NoDecentBackendException(position));
        }
    }

    @Override
    public void failed(final Exception e) {
        RequestErrorType errorType =
            RequestErrorType.ERROR_CLASSIFIER.apply(e);

        if (errorType == RequestErrorType.NON_RETRIABLE) {
            if (requests.getAndSet(0) > 0) {
                callback.failed(e);
            }

            return;
        }

        if (requests.decrementAndGet() == 0) {
            callback.failed(new NoDecentBackendException(position));
        }
    }

    @Override
    public void cancelled() {
        if (requests.decrementAndGet() == 0) {
            callback.cancelled();
        }
    }

    public static final class NoDecentBackendException
        extends ServerException
    {
        private static final long serialVersionUID = -166775444087654456L;

        public NoDecentBackendException(final long position) {
            super(
                HttpStatus.SC_INTERNAL_SERVER_ERROR,
                "No backend with position greater or equal " + position);
        }
    }
}