package ru.yandex.msearch.proxy.api.async.mail.subscriptions;

import org.apache.http.HttpException;
import ru.yandex.search.rules.RequestParams;
import ru.yandex.search.rules.SearchInfo;
import ru.yandex.search.rules.SearchRequest;
import ru.yandex.search.rules.SearchRule;

public class SelectSubscriptionRule
    implements SearchRule<SubscriptionsStat, RequestParams, SearchInfo>
{
    private final FastSubscriptionsRule fastRule;
    private final FullScanSubscriptionsRule fullScan;

    public SelectSubscriptionRule(
        final FastSubscriptionsRule fastRule,
        final FullScanSubscriptionsRule fullScan)
    {
        this.fastRule = fastRule;
        this.fullScan = fullScan;
    }

    @Override
    public void execute(
        final SearchRequest<SubscriptionsStat, RequestParams, SearchInfo> request)
        throws HttpException
    {
        boolean fast = request.cgiParams().getBoolean("fast", true);
        if (fast) {
            fastRule.execute(request);
        } else {
            fullScan.execute(request);
        }
    }
}
