package ru.yandex.msearch.proxy.api.async.mail.subscriptions;

public class SubscriptionEntry {
    private final String from;
    private String displayName;
    private final String searchRequest;
    private final SubscriptionStatus status;
    private final String mid;
    private long total;
    private long date;
    private long read;
    private long shows;

    public SubscriptionEntry(
        final String mid,
        final String from,
        final String displayName,
        final String searchRequest,
        final long date,
        final long total,
        final long read,
        final long shows)
    {
        this.mid = mid;
        this.from = from;
        this.displayName = displayName;
        this.searchRequest = searchRequest;
        this.total = total;
        this.read = read;
        this.shows = shows;
        this.date = date;
        this.status = null;
    }

    public SubscriptionEntry(
        final SubscriptionStatus status,
        final String from,
        final String displayName,
        final long date,
        final long total,
        final long read,
        final long shows)
    {
        this.mid = "";
        this.from = from;
        this.displayName = displayName;
        this.searchRequest = "";
        this.total = total;
        this.read = read;
        this.shows = shows;
        this.date = date;
        this.status = status;
    }

    public SubscriptionEntry displayName(final String displayName) {
        this.displayName = displayName;
        return this;
    }

    public String from() {
        return from;
    }

    public String displayName() {
        return displayName;
    }

    public String searchEmail() {
        return searchRequest;
    }

    public void incTotal(final long inc) {
        this.total += inc;
    }

    public void incSeenFlag(final long inc) {
        this.read += inc;
    }

    public void incShows(final long inc) {
        this.shows += inc;
    }

    public long total() {
        if (total > 0L) {
            return total;
        } else {
            return 0L;
        }
    }

    public long seenFlag() {
        return read;
    }

    public long shows() {
        return shows;
    }

    public double percentFlagSeen() {
        if (total > 0L) {
            return 100d * read / total;
        } else {
            return 0d;
        }
    }

    public double percentShow() {
        if (total > 0L) {
            return 100d * shows / total;
        } else {
            return 0d;
        }
    }

    public String mid() {
        return mid;
    }

    public long date() {
        return date;
    }
}
