package ru.yandex.msearch.proxy.api.async.mail.subscriptions;

import java.util.LinkedHashSet;
import java.util.Set;
import java.util.logging.Logger;

import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.http.util.nio.client.AbstractAsyncClient;
import ru.yandex.http.util.nio.client.AsyncClient;
import ru.yandex.json.writer.JsonType;
import ru.yandex.json.writer.JsonTypeExtractor;
import ru.yandex.mail.search.subscriptions.SubscriptionsConstants;
import ru.yandex.msearch.proxy.AsyncHttpServer;
import ru.yandex.parser.searchmap.User;
import ru.yandex.parser.string.CollectionParser;
import ru.yandex.parser.string.EnumParser;
import ru.yandex.parser.uri.CgiParams;
import ru.yandex.search.prefix.LongPrefix;
import ru.yandex.search.proxy.universal.UniversalSearchProxyRequestContext;

public class SubscriptionsBaseContext implements UniversalSearchProxyRequestContext
{
    private static final CollectionParser<SubscriptionStatus, Set<SubscriptionStatus>, RuntimeException> STATUS_SET_PARSER =
        new CollectionParser<>(
            new EnumParser<>(SubscriptionStatus.class),
            LinkedHashSet::new);

    private final long uid;
    private final User user;
    private final AsyncClient client;
    private final ProxySession session;
    private final JsonType jsonType;
    private final boolean optIn;
    private final long currentTime;
    private final long optInTurnTime;

    public SubscriptionsBaseContext(
        final AsyncHttpServer proxy,
        final ProxySession session)
        throws BadRequestException
    {
        this.session = session;
        CgiParams params = session.params();
        uid = params.getLong("uid");
        jsonType = JsonTypeExtractor.NORMAL.extract(params);
        optIn = params.getBoolean("opt_in_subs", false);

        user = new User(SubscriptionsConstants.SUBSCRIPTIONS_SERVICE, new LongPrefix(uid));
        client = proxy.searchClient().adjust(session.context());
        currentTime = System.currentTimeMillis() / 1000;
        optInTurnTime = session.params().getLong("opt_in_subs_at", currentTime);
    }

    public boolean optIn() {
        return optIn;
    }

    public JsonType jsonType() {
        return jsonType;
    }

    public ProxySession session() {
        return session;
    }

    @Override
    public User user() {
        return user;
    }

    @Override
    public Long minPos() {
        return null;
    }

    @Override
    public AbstractAsyncClient<?> client() {
        return client;
    }

    @Override
    public Logger logger() {
        return session.logger();
    }

    @Override
    public long lagTolerance() {
        return 0L;
    }

    public long optInTurnTime() {
        return optInTurnTime;
    }

    public long currentTime() {
        return currentTime;
    }
}